<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDriversTable extends Migration {

	public function up()
	{
		Schema::create('drivers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('mobile')->unique();
			$table->string('address');
			$table->string('password');
			$table->string('login_type');
			$table->integer('social_id');
			$table->integer('national_id');
			$table->string('national_image')->nullable();
			$table->string('image')->nullable();
			$table->string('driving_license')->nullable();
			$table->string('drug_analysis')->nullable();
			$table->string('record_certificate')->nullable();
			$table->enum('online_status', array('online', 'offline'))->nullable();
			$table->time('time_online')->nullable();
			$table->enum('notifystatus', array('on', 'off'))->nullable();
			$table->string('profits')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('drivers');
	}
}