<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('message');
			$table->integer('client_id')->nullable();
			$table->string('driver_id')->nullable();
			$table->integer('conversation_id');
			$table->boolean('is_read')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}