<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->string('content');
			$table->string('image')->nullable();
			$table->enum('is_read', array('on', 'off'));
			$table->integer('client_id')->nullable();
			$table->string('driver_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}