<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTripsTable extends Migration {

	public function up()
	{
		Schema::create('trips', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('from_address');
			$table->float('from_lat');
			$table->float('from_lng');
			$table->string('to_address');
			$table->float('to_lat');
			$table->float('to_lng');
			$table->enum('status', array('cancelbefore', 'cancelafter', 'completed', 'accepted'));
			$table->string('cancel_text');
			$table->integer('total_distance')->nullable();
			$table->time('trip_duration')->nullable();
			$table->string('trip_salary')->nullable();
			$table->string('tax')->nullable();
			$table->string('total_salary')->nullable();
			$table->integer('car_id');
			$table->integer('cient_id');
			$table->integer('promocode_id');
		});
	}

	public function down()
	{
		Schema::drop('trips');
	}
}