<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'password', 'role');

    public function orders()
    {
        return $this->hasMany('\User', 'user_id');
    }

    public function payments()
    {
        return $this->hasMany('\Payment');
    }

    public function subscriptions()
    {
        return $this->hasMany('Subscription');
    }

    public function reports()
    {
        return $this->hasMany('\Report');
    }

}