<?php

namespace App\Models;

class Address extends Eloquent {

	protected $table = 'addresses';
	public $timestamps = true;
	protected $fillable = array('nickname', 'address', 'street', 'street_additional', 'city', 'state', 'country', 'zipcode', 'latitude', 'longitude');
	protected $visible = array('nickname', 'address', 'street', 'street_additional', 'city', 'state', 'country', 'zipcode', 'latitude', 'longitude');

	public function user()
	{
		return $this->belongsTo('App\Models\User')->withPivot('address_pivot');
	}

}