<?php

namespace App\Models;

class Page extends Eloquent {

	protected $table = 'pages';
	public $timestamps = true;
	protected $fillable = array('title', 'slug', 'meta_title', 'meta_description', 'meta_keywords', 'content', 'section_id', 'author_id', 'page_path', 'menu_route', 'slider_id', 'excerpt');
	protected $visible = array('title', 'slug', 'meta_title', 'meta_description', 'meta_keywords', 'content', 'section_id', 'author_id', 'page_path', 'menu_route', 'slider_id', 'excerpt');

	public function sections()
	{
		return $this->hasMany('App\Models\PageSection');
	}

	public function author()
	{
		return $this->hasMany('App\Models\User', 'id', 'author_id');
	}

	public function slider()
	{
		return $this->hasOne('App\Models\Slider');
	}

}