<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Products extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('available_on', 'product_info');
	protected $visible = array('available_on', 'product_info');

	public function option()
	{
		return $this->hasMany('App\Models\ProductOption');
	}

	public function variants()
	{
		return $this->hasManyThrough('App\Models\ProductVariant');
	}

	public function images()
	{
		return $this->hasManyThrough('App\Models\ProductImage');
	}

	public function details()
	{
		return $this->hasOne('App\Models\ProductsTranslations');
	}

	public function orderItem()
	{
		return $this->belongsTo('App\Models\OrderItem');
	}

}