<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagesTable extends Migration {

	public function up()
	{
		Schema::create('pages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 65)->index();
			$table->string('slug')->nullable();
			$table->string('meta_title', 65)->nullable();
			$table->text('meta_description')->nullable();
			$table->string('meta_keywords')->nullable();
			$table->text('content')->nullable();
			$table->integer('section_id')->unsigned();
			$table->integer('author_id')->unsigned()->nullable();
			$table->boolean('is_published')->default(0);
			$table->string('lang', 20);
			$table->timestamps();
			$table->string('page_path')->nullable();
			$table->string('menu_route')->nullable();
			$table->integer('slider_id')->unsigned()->nullable();
			$table->text('excerpt')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('pages');
	}
}