<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ApiKeys extends Eloquent {

	protected $table = 'api_keys';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('key', 'user_id', 'level', 'ignore_limits');
	protected $visible = array('key', 'level', 'ignore_limits');

	public function user_api_key()
	{
		return $this->belongsTo('Profile', 'id', 'api_key_id');
	}

}