<?php

namespace App\Models;

class ProductsTranslations extends Eloquent {

	protected $table = 'products_translations';
	public $timestamps = true;
	protected $fillable = array('product_id', 'slug', 'name', 'short_description', 'description', 'meta_keywords', 'meta_description', 'htmlschema', 'bodyschema', 'locale');
	protected $visible = array('product_id', 'slug', 'name', 'short_description', 'description', 'meta_keywords', 'meta_description', 'htmlschema', 'bodyschema', 'locale');

	public function product()
	{
		return $this->belongsTo('App\Models\Products');
	}

	public function productVariants()
	{
		return $this->hasManyThrough('App\Models\ProductVariant');
	}

	public function productOptions()
	{
		return $this->hasManyThrough('App\Models\ProductOption');
	}

	public function productImages()
	{
		return $this->hasManyThrough('App\Models\ProductImage');
	}

}