<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'password');

    public function contacts()
    {
        return $this->hasMany('\Contact');
    }

    public function articles()
    {
        return $this->belongsToMany('\Article');
    }

    public function bloodType()
    {
        return $this->belongsTo('\BloodType', 'blood_type_id');
    }

    public function bloodTypesForDonation()
    {
        return $this->belongsToMany('\BloodType');
    }

    public function governorate()
    {
        return $this->belongsTo('\Governorate');
    }

    public function governoratesForDonation()
    {
        return $this->belongsToMany('\Governorate');
    }

    public function donationRequests()
    {
        return $this->belongsToMany('\DonationRequest');
    }

}