<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCitizensTable extends Migration {

	public function up()
	{
		Schema::create('Citizens', function(Blueprint $table) {
			$table->increments('identity');
			$table->date('expiryDate');
			$table->string('name');
			$table->enum('gender', array('male', 'female'));
			$table->string('telephone');
			$table->string('emailAddress');
			$table->string('job');
			$table->string('workPlace');
			$table->enum('governorate', array(''));
			$table->enum('region', array(''));
		});
	}

	public function down()
	{
		Schema::drop('Citizens');
	}
}