<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePerfilTable extends Migration {

	public function up()
	{
		Schema::create('perfil', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('firstname');
			$table->string('lastname');
			$table->string('avatar');
			$table->string('phone');
			$table->string('country');
			$table->enum('status', array('active', 'inactive'));
			$table->enum('banned', array('active', 'inactive'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('perfil');
	}
}