<?php

namespace Mediapress/Core/Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Criteria extends Model 
{

    protected $table = 'criterias';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function details()
    {
        return $this->hasMany('CriteriaDetail');
    }

    public function sitemap()
    {
        return $this->belongsTo('Sitemap');
    }

}