<?php

namespace Mediapress/Core/Models;

use Illuminate\Database\Eloquent\Model;

class CriteriaDetail extends Model 
{

    protected $table = 'criteria_details';
    public $timestamps = false;

    public function criteria()
    {
        return $this->belongsTo('Criteria');
    }

    public function url()
    {
        return $this->morphOne('Url', 'model')->where('type','original');
    }

    public function extras()
    {
        return $this->hasMany('Extra', 'model');
    }

}