<?php

namespace Mediapress/Core/Models;

use Illuminate\Database\Eloquent\Model;

class PageDetail extends Model 
{

    protected $table = 'page_details';
    public $timestamps = false;

    public function pages()
    {
        return $this->belongsTo('Page');
    }

    public function extras()
    {
        return $this->hasMany('PageDetailExtra');
    }

    public function language()
    {
        return $this->belongsTo('Language');
    }

    public function url()
    {
        return $this->morphOne('Url', 'model')->where('type','original');
    }

}