<?php

namespace Mediapress/Core/Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sitemap extends Model 
{

    protected $table = 'sitemaps';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function details()
    {
        return $this->hasMany('SitemapDetail');
    }

    public function categories()
    {
        return $this->hasMany('Category');
    }

    public function module()
    {
        return $this->belongsTo('Module');
    }

    public function website()
    {
        return $this->belongsTo('Website');
    }

}