<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSitemapsTable extends Migration {

	public function up()
	{
		Schema::create('sitemaps', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('module_id')->unsigned()->index();
			$table->integer('website_id')->unsigned()->index();
			$table->timestamps();
			$table->softDeletes();
			$table->enum('category', array('0', '1'));
		});
	}

	public function down()
	{
		Schema::drop('sitemaps');
	}
}