<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWebsitesTable extends Migration {

	public function up()
	{
		Schema::create('websites', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('slug');
			$table->enum('type', array('domain', 'folder', 'alias'));
			$table->string('sort');
			$table->integer('website_id')->nullable()->index();
			$table->enum('default', array('0', '1'));
			$table->enum('hide_default_language', array('0', '1'));
			$table->enum('ssl', array('-1', '0', '1'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('websites');
	}
}