<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('sitemaps', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('modules')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sitemaps', function(Blueprint $table) {
			$table->foreign('website_id')->references('id')->on('websites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sitemap_details', function(Blueprint $table) {
			$table->foreign('sitemap_id')->references('id')->on('sitemaps')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sitemap_details', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->foreign('sitemap_id')->references('id')->on('sitemaps')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('page_details', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('page_details', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('page_detail_extras', function(Blueprint $table) {
			$table->foreign('page_detail_id')->references('id')->on('page_details')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('sitemap_id')->references('id')->on('sitemaps')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_details', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_details', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('criterias', function(Blueprint $table) {
			$table->foreign('sitemap_id')->references('id')->on('sitemaps')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('criterias', function(Blueprint $table) {
			$table->foreign('criteria_id')->references('id')->on('criterias')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('criteria_details', function(Blueprint $table) {
			$table->foreign('criteria_id')->references('id')->on('criterias')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->foreign('sitemap_id')->references('id')->on('sitemaps')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('criterias')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('property_details', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('properties')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_page', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_page', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('criteria_page', function(Blueprint $table) {
			$table->foreign('criteria_id')->references('id')->on('criterias')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('criteria_page', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('page_detail_property_detail', function(Blueprint $table) {
			$table->foreign('page_detail_id')->references('id')->on('page_details')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('page_detail_property_detail', function(Blueprint $table) {
			$table->foreign('property_detail_id')->references('id')->on('property_details')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('modules', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('modules')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('language_website', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('language_website', function(Blueprint $table) {
			$table->foreign('website_id')->references('id')->on('websites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_criteria', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_criteria', function(Blueprint $table) {
			$table->foreign('criteria_id')->references('id')->on('criterias')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_property', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_property', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('properties')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('routes', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_route', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_route', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->foreign('image_id')->references('id')->on('images')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->foreign('gallery_id')->references('id')->on('galleries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('sitemaps', function(Blueprint $table) {
			$table->dropForeign('sitemaps_module_id_foreign');
		});
		Schema::table('sitemaps', function(Blueprint $table) {
			$table->dropForeign('sitemaps_website_id_foreign');
		});
		Schema::table('sitemap_details', function(Blueprint $table) {
			$table->dropForeign('sitemap_details_sitemap_id_foreign');
		});
		Schema::table('sitemap_details', function(Blueprint $table) {
			$table->dropForeign('sitemap_details_language_id_foreign');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->dropForeign('pages_sitemap_id_foreign');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->dropForeign('pages_page_id_foreign');
		});
		Schema::table('page_details', function(Blueprint $table) {
			$table->dropForeign('page_details_page_id_foreign');
		});
		Schema::table('page_details', function(Blueprint $table) {
			$table->dropForeign('page_details_language_id_foreign');
		});
		Schema::table('page_detail_extras', function(Blueprint $table) {
			$table->dropForeign('page_detail_extras_page_detail_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_sitemap_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_category_id_foreign');
		});
		Schema::table('category_details', function(Blueprint $table) {
			$table->dropForeign('category_details_category_id_foreign');
		});
		Schema::table('category_details', function(Blueprint $table) {
			$table->dropForeign('category_details_language_id_foreign');
		});
		Schema::table('criterias', function(Blueprint $table) {
			$table->dropForeign('criterias_sitemap_id_foreign');
		});
		Schema::table('criterias', function(Blueprint $table) {
			$table->dropForeign('criterias_criteria_id_foreign');
		});
		Schema::table('criteria_details', function(Blueprint $table) {
			$table->dropForeign('criteria_details_criteria_id_foreign');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->dropForeign('properties_sitemap_id_foreign');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->dropForeign('properties_property_id_foreign');
		});
		Schema::table('property_details', function(Blueprint $table) {
			$table->dropForeign('property_details_property_id_foreign');
		});
		Schema::table('category_page', function(Blueprint $table) {
			$table->dropForeign('category_page_category_id_foreign');
		});
		Schema::table('category_page', function(Blueprint $table) {
			$table->dropForeign('category_page_page_id_foreign');
		});
		Schema::table('criteria_page', function(Blueprint $table) {
			$table->dropForeign('criteria_page_criteria_id_foreign');
		});
		Schema::table('criteria_page', function(Blueprint $table) {
			$table->dropForeign('criteria_page_page_id_foreign');
		});
		Schema::table('page_detail_property_detail', function(Blueprint $table) {
			$table->dropForeign('page_detail_property_detail_page_detail_id_foreign');
		});
		Schema::table('page_detail_property_detail', function(Blueprint $table) {
			$table->dropForeign('page_detail_property_detail_property_detail_id_foreign');
		});
		Schema::table('modules', function(Blueprint $table) {
			$table->dropForeign('modules_module_id_foreign');
		});
		Schema::table('language_website', function(Blueprint $table) {
			$table->dropForeign('language_website_language_id_foreign');
		});
		Schema::table('language_website', function(Blueprint $table) {
			$table->dropForeign('language_website_website_id_foreign');
		});
		Schema::table('category_criteria', function(Blueprint $table) {
			$table->dropForeign('category_criteria_category_id_foreign');
		});
		Schema::table('category_criteria', function(Blueprint $table) {
			$table->dropForeign('category_criteria_criteria_id_foreign');
		});
		Schema::table('category_property', function(Blueprint $table) {
			$table->dropForeign('category_property_category_id_foreign');
		});
		Schema::table('category_property', function(Blueprint $table) {
			$table->dropForeign('category_property_property_id_foreign');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->dropForeign('admins_group_id_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_group_id_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_role_id_foreign');
		});
		Schema::table('routes', function(Blueprint $table) {
			$table->dropForeign('routes_role_id_foreign');
		});
		Schema::table('role_route', function(Blueprint $table) {
			$table->dropForeign('role_route_group_id_foreign');
		});
		Schema::table('role_route', function(Blueprint $table) {
			$table->dropForeign('role_route_role_id_foreign');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->dropForeign('medias_image_id_foreign');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->dropForeign('images_gallery_id_foreign');
		});
	}
}