<?php

namespace Mediapress/Core/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('sitemap_id', 'category_id', '_lft', '_rgt', '_dpt');

	public function sitemap()
	{
		return $this->belongsTo('Sitemap');
	}

	public function details()
	{
		return $this->hasMany('CategoryDetail');
	}

}