<?php

namespace Mediapress/Core/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Criteria extends Eloquent {

	protected $table = 'criterias';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function details()
	{
		return $this->hasMany('CriteriaDetail');
	}

	public function sitemap()
	{
		return $this->belongsTo('Sitemap');
	}

}