<?php

namespace Mediapress/Core/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Page extends Eloquent {

	protected $table = 'pages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function details()
	{
		return $this->hasMany('PageDetail');
	}

	public function sitemap()
	{
		return $this->belongsTo('Sitemap');
	}

}