<?php

namespace Mediapress/Core/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Website extends Eloquent {

	protected $table = 'websites';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function languages()
	{
		return $this->belongsToMany('Language')->withPivot('default');
	}

	public function sitemaps()
	{
		return $this->hasMany('Sitemap');
	}

}