<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidateExperiencesTable extends Migration {

	public function up()
	{
		Schema::create('candidate_experiences', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('candidate_id');
			$table->integer('industry_id');
			$table->string('position', 191);
			$table->string('company', 191);
			$table->text('description');
			$table->date('start_date');
			$table->date('end_date');
			$table->boolean('is_current')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('candidate_experiences');
	}
}