<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMicroJobsTable extends Migration {

	public function up()
	{
		Schema::create('micro_jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('job_id');
			$table->string('wage_type', 191)->default('fixed');
			$table->integer('price');
			$table->float('estimated_hours');
			$table->tinyInteger('is_scheduled')->default('1');
			$table->date('date_from');
			$table->date('date_to');
			$table->string('time_from');
			$table->string('time_to');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('micro_jobs');
	}
}