<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email', 191)->unique();
			$table->string('password', 191);
			$table->integer('user_type_id');
			$table->boolean('allow_email_notifications')->default(true);
			$table->boolean('allow_push_notifications')->default(true);
			$table->integer('site_lang_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}