<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id');
			$table->string('company_name');
			$table->text('company_logo');
			$table->string('title');
			$table->text('description');
			$table->text('image');
			$table->text('address');
			$table->integer('region_id');
			$table->date('application_deadline')->nullable();
			$table->date('published_date')->nullable();
			$table->timestamps();
			$table->tinyInteger('status');
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}