<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Compte extends Eloquent {

	protected $table = 'comptes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'id_client', 'telephone', 'etat');
	protected $visible = array('slug', 'id_client', 'telephone', 'etat');

	public function client()
	{
		return $this->belongsTo('App\Client', 'id_client');
	}

	public function depot()
	{
		return $this->hasMany('App\Depot', 'id_depot');
	}

}