<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Retrait extends Eloquent {

	protected $table = 'retraits';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id_client', 'id_createur', 'id_agence', 'montant', 'etat', 'slug');
	protected $visible = array('id_client', 'id_createur', 'id_agence', 'montant', 'etat', 'slug');

	public function client()
	{
		return $this->belongsTo('App\Client', 'id_client');
	}

	public function createur()
	{
		return $this->belongsTo('App\Utilisateur', 'id_createur');
	}

	public function agence()
	{
		return $this->belongsTo('App\Agence', 'id_agence');
	}

}