<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('number')->nullable();
			$table->bigInteger('company_id')->unsigned();
			$table->bigInteger('vehicle_id')->unsigned();
			$table->bigInteger('driver_id')->unsigned();
			$table->string('driver_number')->nullable();
			$table->bigInteger('station_id')->unsigned();
			$table->enum('fuel_type', array('91', '95', 'diesel'))->nullable();
			$table->integer('letres')->unsigned()->nullable();
			$table->string('total_price')->nullable();
			$table->bigInteger('employe_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}