<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCardTable extends Migration {

	public function up()
	{
		Schema::create('card', function(Blueprint $table) {
			$table->uuid('id')->unique();
			$table->uuid('portal_user_id')->nullable();
			$table->timestamps();
			$table->string('title');
			$table->string('image');
			$table->longText('content');
			$table->string('display_to');
		});
	}

	public function down()
	{
		Schema::drop('card');
	}
}