<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClubsTable extends Migration {

	public function up()
	{
		Schema::create('clubs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('num_id')->index();
			$table->string('logo', 255);
			$table->string('nom', 100);
			$table->string('adresse');
			$table->date('date_affiliation');
			$table->string('email', 200);
			$table->integer('tel');
			$table->string('ville', 255);
			$table->integer('code_post');
			$table->string('url_club', 200);
			$table->string('fb_club', 255);
			$table->string('youtube_club', 255);
			$table->string('instagram_club', 255);
			$table->string('color_maillot1', 255);
			$table->string('color_maillot2', 255);
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->integer('comite_id')->unsigned();
			$table->boolean('valide')->default(0);
			$table->integer('type_cotisation_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('clubs');
	}
}