<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLicencesTable extends Migration {

	public function up()
	{
		Schema::create('licences', function(Blueprint $table) {
			$table->increments('id');
			$table->string('photo');
			$table->string('nom', 100);
			$table->string('prenom', 100);
			$table->integer('age');
			$table->date('date_naissance');
			$table->decimal('taille');
			$table->decimal('poids');
			$table->string('adresse', 255);
			$table->integer('code_post');
			$table->integer('tel_portable');
			$table->integer('tel_fixe');
			$table->string('autre_activite');
			$table->string('imprime_file');
			$table->string('identity_file');
			$table->string('titre_sejour_file');
			$table->string('autorisation_travail_file');
			$table->string('certificat_medical_file');
			$table->string('contrat_travail_file');
			$table->string('attestation_joueur_amateur_file');
			$table->integer('type_licence_id')->unsigned();
			$table->integer('comite_id')->unsigned();
			$table->integer('civilite_id')->unsigned();
			$table->integer('ligue_id')->unsigned();
			$table->integer('nationalite_id')->unsigned();
			$table->integer('club_id')->unsigned();
			$table->integer('sanction_id')->unsigned();
			$table->integer('categorie_age_id')->unsigned();
			$table->timestamps();
			$table->integer('level_id')->unsigned();
			$table->integer('organisme_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->date('validation_date');
			$table->boolean('valide')->default(0);
			$table->boolean('payer')->default(0);
			$table->integer('saison_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('licences');
	}
}