<?php

namespace App;

class Club extends Eloquent {

	protected $table = 'clubs';
	public $timestamps = true;
	protected $fillable = array('num_id', 'logo', 'adresse', 'email', 'tel', 'ville', 'code_post', 'url_club', 'youtube_club', 'instagram_club', 'color_maillot1', 'color_maillot2', 'valide');

	public function licences()
	{
		return $this->hasMany('App\Licence');
	}

	public function dirigeants()
	{
		return $this->hasMany('App\Dirigeant');
	}

	public function equipes()
	{
		return $this->hasMany('App\Equipe');
	}

	public function user()
	{
		return $this->belongsTo('App\User');
	}

	public function comite()
	{
		return $this->belongsTo('App\Comite');
	}

	public function bordereau()
	{
		return $this->belongsTo('App\Bordereau');
	}

	public function cotisation()
	{
		return $this->belongsTo('App\Cotisation');
	}

}