<?php

namespace App;

class Licence extends Eloquent {

	protected $table = 'licences';
	public $timestamps = true;
	protected $fillable = array('photo', 'age', 'date_naissance', 'taille', 'poids', 'code_post', 'tel_portable', 'tel_fixe', 'autre_activite', 'imprime_file', 'identity_file', 'titre_sejour_file', 'autorisation_travail_file', 'certificat_medical_file', 'contrat_travail_file', 'attestation_joueur_amateur_file', 'validation_date', 'valide', 'payer');

	public function club()
	{
		return $this->belongsTo('App\Club');
	}

	public function type_licence()
	{
		return $this->belongsTo('App\TypeLicence');
	}

	public function sanction()
	{
		return $this->belongsTo('App\Sanction');
	}

	public function nationalite()
	{
		return $this->belongsTo('App\Nationalite');
	}

	public function civilite()
	{
		return $this->belongsTo('App\Civilite');
	}

	public function comite()
	{
		return $this->belongsTo('App\Comite');
	}

	public function ligue()
	{
		return $this->belongsTo('App\Ligue');
	}

	public function categorie_age()
	{
		return $this->belongsTo('App\CategorieAge');
	}

	public function level()
	{
		return $this->belongsTo('App\Level');
	}

	public function user()
	{
		return $this->belongsTo('App\User');
	}

	public function organisme()
	{
		return $this->belongsTo('App\Organisme');
	}

	public function saison()
	{
		return $this->belongsTo('App\Saison');
	}

	public function sous_type_licence()
	{
		return $this->belongsTo('App\SousTypeLicence');
	}

}