<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Plan extends Model 
{

    protected $table = 'planes';
    public $timestamps = true;
    protected $fillable = array('nombre', 'descripcion', 'telefonicas_id', 'plazos_id');
    protected $visible = array('nombre', 'descripcion', 'telefonicas_id', 'plazos_id');

    public function telefonica()
    {
        return $this->hasOne('App\Telefonica');
    }

    public function plazo()
    {
        return $this->belongsTo('App\Plazo');
    }

}