<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('roles_id', 'email', 'rememberToken', 'empresas_id', 'password', 'ordenes_id');
    protected $visible = array('roles_id', 'email', 'empresas_id', 'password', 'ordenes_id');
    protected $hidden = array('rememberToken');

    public function user()
    {
        return $this->hasOne('App\User', 'roles_id');
    }

    public function empresa()
    {
        return $this->hasOne('App\Empresa');
    }

    public function ordenes()
    {
        return $this->hasMany('App\User');
    }

}