<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSchedulesTable extends Migration {

	public function up()
	{
		Schema::create('schedules', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('chamber_id')->unsigned();
			$table->enum('day', array('SAT', 'SUN', 'MON', 'WED', 'THU', 'FRI'));
			$table->time('start_time');
			$table->string('end_time');
			$table->boolean('status');
		});
	}

	public function down()
	{
		Schema::drop('schedules');
	}
}