<?php

class ParentCreditCardTransaction extends Eloquent {

	protected $table = 'bf_credit_cards_transactions';
	public $timestamps = false;
	protected $fillable = array('child_credit_card_id', 'transaction_date', 'transaction_bank_id', 'transaction_detail', 'transaction_amount', 'transaction_category_id', 'reconciliation_status');
	protected $visible = array('child_credit_card_id', 'transaction_date', 'transaction_bank_id', 'transaction_detail', 'transaction_amount', 'transaction_category_id', 'reconciliation_status');

	public function reconciliation()
	{
		return $this->hasOne('ParentCreditCardReconciliation', 'transaction_id');
	}

	public function category()
	{
		return $this->belongsTo('FinanceCategory');
	}

}