<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'phone', 'city_id', 'password', 'type', 'image');

    public function reports()
    {
        return $this->hasMany('App/Models\Reports');
    }

    public function adds()
    {
        return $this->hasMany('App/Models\Product');
    }

    public function favorites()
    {
        return $this->hasMany('App/Models\Favorite');
    }

    public function ratings()
    {
        return $this->hasMany('App/Models\Rating');
    }

    public function promotedUser()
    {
        return $this->hasOne('App/Models\PromotedUser');
    }

    public function city()
    {
        return $this->belongsTo('App/Models\City');
    }

    public function messages()
    {
        return $this->hasMany('App/Models\Product');
    }

}