<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePromotedUsersTable extends Migration {

	public function up()
	{
		Schema::create('promotedUsers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->text('about');
			$table->string('cover_image');
			$table->string('link');
			$table->integer('pakage_id')->unsigned();
			$table->boolean('is_active');
			$table->timestamps();
			$table->datetime('start_date');
			$table->datetime('end_date');
		});
	}

	public function down()
	{
		Schema::drop('promotedUsers');
	}
}