<?php

namespace App/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'is_valid', 'status', 'is_checked', 'discount_ratio', 'price', 'category_id', 'description');
	protected $visible = array('user_id');

	public function user()
	{
		return $this->belongsTo('App/Models\User');
	}

	public function images()
	{
		return $this->hasMany('App/Models\Image', 'imagable');
	}

	public function category()
	{
		return $this->belongsTo('App/Models\Category');
	}

	public function getRatingsAttributes()
	{
		return $this->hasMany('App/Models\Product');
	}

}