<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('branches', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('curreny_id')->references('id')->on('currencies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('customer_name')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('order_status')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('warehouses', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('warehouses', function(Blueprint $table) {
			$table->foreign('phone')->references('id')->on('Phone')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('shipments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('shipments', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('settings_data', function(Blueprint $table) {
			$table->foreign('setting_id')->references('id')->on('settings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('settings_data', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('country_data', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('country_data', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('state_data', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('state_data', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('city_data', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('city_data', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_data', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('branch_data', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_user', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('branch_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('banner_data', function(Blueprint $table) {
			$table->foreign('banner_id')->references('id')->on('banners')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('banner_data', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('slider_data', function(Blueprint $table) {
			$table->foreign('slider_id')->references('id')->on('sliders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('slider_data', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('blog_categories_data', function(Blueprint $table) {
			$table->foreign('blog_category_id')->references('id')->on('blog_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('blog_categories_data', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('blogs', function(Blueprint $table) {
			$table->foreign('blog_category_id')->references('id')->on('blog_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('blog_data', function(Blueprint $table) {
			$table->foreign('blog_id')->references('id')->on('blogs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('blog_data', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('branches', function(Blueprint $table) {
			$table->dropForeign('branches_city_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_state_id_foreign');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->dropForeign('states_country_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_curreny_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_customer_name_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_city_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_status_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_country_id_foreign');
		});
		Schema::table('warehouses', function(Blueprint $table) {
			$table->dropForeign('warehouses_city_id_foreign');
		});
		Schema::table('warehouses', function(Blueprint $table) {
			$table->dropForeign('warehouses_phone_foreign');
		});
		Schema::table('shipments', function(Blueprint $table) {
			$table->dropForeign('shipments_user_id_foreign');
		});
		Schema::table('shipments', function(Blueprint $table) {
			$table->dropForeign('shipments_city_id_foreign');
		});
		Schema::table('settings_data', function(Blueprint $table) {
			$table->dropForeign('settings_data_setting_id_foreign');
		});
		Schema::table('settings_data', function(Blueprint $table) {
			$table->dropForeign('settings_data_lang_id_foreign');
		});
		Schema::table('country_data', function(Blueprint $table) {
			$table->dropForeign('country_data_country_id_foreign');
		});
		Schema::table('country_data', function(Blueprint $table) {
			$table->dropForeign('country_data_lang_id_foreign');
		});
		Schema::table('state_data', function(Blueprint $table) {
			$table->dropForeign('state_data_state_id_foreign');
		});
		Schema::table('state_data', function(Blueprint $table) {
			$table->dropForeign('state_data_lang_id_foreign');
		});
		Schema::table('city_data', function(Blueprint $table) {
			$table->dropForeign('city_data_city_id_foreign');
		});
		Schema::table('city_data', function(Blueprint $table) {
			$table->dropForeign('city_data_lang_id_foreign');
		});
		Schema::table('branch_data', function(Blueprint $table) {
			$table->dropForeign('branch_data_branch_id_foreign');
		});
		Schema::table('branch_data', function(Blueprint $table) {
			$table->dropForeign('branch_data_lang_id_foreign');
		});
		Schema::table('branch_user', function(Blueprint $table) {
			$table->dropForeign('branch_user_branch_id_foreign');
		});
		Schema::table('branch_user', function(Blueprint $table) {
			$table->dropForeign('branch_user_user_id_foreign');
		});
		Schema::table('banner_data', function(Blueprint $table) {
			$table->dropForeign('banner_data_banner_id_foreign');
		});
		Schema::table('banner_data', function(Blueprint $table) {
			$table->dropForeign('banner_data_lang_id_foreign');
		});
		Schema::table('slider_data', function(Blueprint $table) {
			$table->dropForeign('slider_data_slider_id_foreign');
		});
		Schema::table('slider_data', function(Blueprint $table) {
			$table->dropForeign('slider_data_lang_id_foreign');
		});
		Schema::table('blog_categories_data', function(Blueprint $table) {
			$table->dropForeign('blog_categories_data_blog_category_id_foreign');
		});
		Schema::table('blog_categories_data', function(Blueprint $table) {
			$table->dropForeign('blog_categories_data_lang_id_foreign');
		});
		Schema::table('blogs', function(Blueprint $table) {
			$table->dropForeign('blogs_blog_category_id_foreign');
		});
		Schema::table('blog_data', function(Blueprint $table) {
			$table->dropForeign('blog_data_blog_id_foreign');
		});
		Schema::table('blog_data', function(Blueprint $table) {
			$table->dropForeign('blog_data_lang_id_foreign');
		});
	}
}