<?php

namespace Branch;

use Illuminate\Database\Eloquent\Model;

class Branch extends Model 
{

    protected $table = 'branches';
    public $timestamps = true;
    protected $fillable = array('branch_name', 'city_id', 'lat', 'lang', 'address', 'phone');
    protected $visible = array('status');

    public function phone()
    {
        return $this->morphMany('Phone', 'phoneable');
    }

    public function data()
    {
        return $this->hasMany('BranchData');
    }

    public function user()
    {
        return $this->belongsToMany('User', 'branch_user', 'branch_id', 'user_id');
    }

}