<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWarehousesTable extends Migration {

	public function up()
	{
		Schema::create('warehouses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->integer('city_id')->unsigned();
			$table->integer('phone')->unsigned();
			$table->text('address');
			$table->string('lat', 191);
			$table->string('lang', 191);
			$table->enum('status', array('open', 'close'));
		});
	}

	public function down()
	{
		Schema::drop('warehouses');
	}
}