<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBidsTable extends Migration {

	public function up()
	{
		Schema::create('bids', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('officer_id')->unsigned()->nullable();
			$table->integer('category_id')->unsigned()->nullable()->index();
			$table->enum('status', array(''creation'', ''inprogress'', ''awarded''));
			$table->string('rfx_number', 30)->index();
			$table->string('rfx_title', 100)->index();
			$table->tinyInteger('is_sealed')->unsigned()->default('0');
			$table->string('contact_name', 100);
			$table->string('contact_title', 100);
			$table->string('contact_email', 100);
			$table->string('contact_phone', 50);
			$table->string('contact_department', 100);
			$table->string('contact_address_1', 250);
			$table->string('contact_address_2', 250);
			$table->string('contact_city', 50);
			$table->string('contact_state', 2);
			$table->string('contact_zip', 9);
			$table->integer('type_id')->unsigned()->nullable();
			$table->string('s_contact_name', 100);
			$table->string('s_contact_title', 100);
			$table->string('s_contact_email', 100);
			$table->string('s_contact_phone', 50);
			$table->enum('approve_type', array('sequential', 'parallel'));
			$table->enum('approve_timing', array('fixed', 'flexible'));
			$table->integer('public_notice_id');
			$table->integer('rubric_id')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('bids');
	}
}