<?php

namespace App\Models;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;
	protected $fillable = array('name', 'country_id', 'photo');

	public function clients()
	{
		return $this->morphToMany('App\Models\Client', '"clientable"');
	}

	public function color()
	{
		return $this->belongsTo('App\Models\Color');
	}

	public function importantDate()
	{
		return $this->hasOne('App\Models\ImportantDates');
	}

}