<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsContentsTable extends Migration {

	public function up()
	{
		Schema::create('items_contents', function(Blueprint $table) {
			$table->integer('id');
			$table->integer('item_id')->unsigned();
			$table->string('title', 255);
			$table->text('content');
			$table->text('description')->nullable();
			$table->text('objectives')->nullable();
			$table->string('return_type')->nullable();
			$table->datetime('set')->nullable();
			$table->datetime('expire')->nullable();
			$table->tinyInteger('state');
			$table->string('grading_template');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('items_contents');
	}
}